<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NotificacaoCobranca extends Model
{
    use HasFactory;

    protected $table = 'notificacoes_cobrancas';

    protected $fillable = [
        'empresa_id',
        'whatsapp',
        'titulo',
        'gateway',
        'status',
        'data_envio',
        'data_vencimento',
        'dias_antes_vencimento',
        'dias_apos_vencimento',
        'criador_id',
        'recorrente',
        'cliente',
        'cpf_cnpj',
        'valor',
    ];

    public function empresa()
    {
        return $this->belongsTo(Empresa::class, 'empresa_id');
    }

    public function historico()
    {
        return $this->hasOne(NotificacaoCobrancaHistorico::class, 'notificacao_cobranca_id')->latest('updated_at');
    }
}
