<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('notificacao_cobrancas_config', function (Blueprint $table) {
            $table->id();
            $table->foreignId('empresa_id')->constrained('empresas')->onDelete('cascade');

            // Paymundi
            $table->string('public_key_cashin_paymundi', 250)->nullable();
            $table->string('public_key_cashout_paymundi', 250)->nullable();
            $table->text('secret_key_cashin_paymundi')->nullable();
            $table->text('secret_key_cashout_paymundi')->nullable();

            // OZN Finance
            $table->string('client_id_onz', 250)->nullable();
            $table->string('client_secret_onz', 250)->nullable();
            $table->text('crt_onz')->nullable();
            $table->text('pfx_onz')->nullable();
            $table->text('key_onz')->nullable();
            $table->string('senha_onz', 250)->nullable();
            $table->longText('access_token_onz')->nullable();
            $table->timestamp('expires_in_onz')->nullable();
            
            // Cobrança
            $table->longText('frase_cobranca')->nullable();
            $table->string('chave_pix', 250)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('notificacao_cobrancas_config');
    }
};
