@extends('layouts.app', ['title' => 'Notificações'])
@section('content')
    <div class="mt-3">
        <div class="row">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <a href="{{ route('notificacao-cobranca.create') }}" class="btn btn-success">
                                <i class="ri-add-circle-fill"></i>
                                Nova Notificação
                            </a>

                            <a href="{{ !$isConnected ? route('notificacao-cobranca.conectar') : '#' }}" class="btn"
                                style="background-color: #25D366; color: white">
                                <i class="ri-whatsapp-line"></i>
                                {{ $isConnected ? 'Conectado' : 'Conectar' }}

                                @if ($isConnected)
                                    - {{ $wppData['name'] }} ({{ $wppData['whatsapp'] }})
                                @endif
                            </a>

                            <a href="{{ route('notificacao-cobranca.config') }}" class="btn btn-primary">
                                <i class="ri-settings-2-line"></i>
                                Configurações
                            </a>
                        </div>
                    </div>
                    <hr class="mt-3">
                    <div class="col-lg-12">
                        {!! Form::open()->fill(request()->all())->get() !!}
                        <div class="row mt-3">
                            <div class="col-md-2">
                                {!! Form::date('start_date', 'Data inicial') !!}
                            </div>
                            <div class="col-md-2">
                                {!! Form::date('end_date', 'Data final') !!}
                            </div>

                            <div class="col-md-2">
                                {!! Form::select('status', 'Status', ['' => 'Todos', '1' => 'Ativo', '0' => 'Desativado'])->attrs([
                                    'class' => 'form-select',
                                ]) !!}
                            </div>

                            <div class="col-md-2">
                                {!! Form::select('gateway', 'Gateway', [
                                    '' => 'Todos',
                                    'pay_mundi' => 'Pay Mundi',
                                    'onz_finance' => 'K1 Bank',
                                ])->attrs(['class' => 'form-select']) !!}
                            </div>

                            <div class="col-md-2">
                                {!! Form::select('recorrente', 'Recorrente', [
                                    '' => 'Todos',
                                    '1' => 'Sim',
                                    '0' => 'Não',
                                ])->attrs(['class' => 'form-select']) !!}
                            </div>

                            <div class="col-lg-2 col-12">
                                <br>
                                <button class="btn btn-primary" type="submit"> <i
                                        class="ri-search-line"></i>Pesquisar</button>
                                <a id="clear-filter" class="btn btn-danger"
                                    href="{{ route('notificacao-cobranca.index') }}"><i
                                        class="ri-eraser-fill"></i>Limpar</a>
                            </div>
                        </div>
                        {!! Form::close() !!}
                    </div>
                    <div class="col-md-12 mt-3">
                        <div class="table-responsive">

                            <table class="table table-centered">
                                <thead class="table-dark">
                                    <tr>
                                        <th>WhatsApp</th>
                                        <th>Cliente</th>
                                        <th>Título</th>
                                        <th>Valor</th>
                                        <th>Gateway</th>
                                        <th>Status</th>
                                        <th>Status última cobrança</th>
                                        <th>Recorrente</th>
                                        <th>Dias antes vencimento</th>
                                        <th>Dias após vencimento</th>
                                        <th>Data vencimento</th>
                                        <th>Data último envio</th>
                                        <th>Data de cadastro</th>
                                        <th>Ações</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($data as $item)
                                        <tr>
                                            <td style="white-space: nowrap">{{ $item->whatsapp }}</td>
                                            <td>{{ $item->cliente }}</td>
                                            <td>{{ $item->titulo }}</td>
                                            <td>R$ {{ number_format($item->valor ?? 0, 2, ',', '.') }}</td>
                                            <td>
                                                @if ($item->gateway == 'pay_mundi')
                                                    Pay Mundi
                                                @else
                                                    ONZ Finance
                                                @endif
                                            </td>
                                            <td>
                                                @if ($item->status)
                                                    <i class="ri-checkbox-circle-fill text-success"></i> Ativo
                                                @else
                                                    <i class="ri-close-circle-fill text-danger"></i> Desativado
                                                @endif
                                            </td>
                                            <td>
                                                @if ($item->historico)
                                                    @switch($item->historico->status)
                                                        @case(0)
                                                            <i class="ri-time-line text-warning"></i> Pendente
                                                        @break

                                                        @case(1)
                                                            <i class="ri-send-plane-fill text-primary"></i> Enviado
                                                        @break

                                                        @case(2)
                                                            <i class="ri-error-warning-fill text-danger"></i> Erro
                                                        @break

                                                        @case(3)
                                                            <i class="ri-checkbox-circle-fill text-success"></i> Pago
                                                        @break

                                                        @default
                                                            <i class="ri-question-line text-secondary"></i> Desconhecido
                                                    @endswitch
                                                @else
                                                    <i class="ri-question-line text-secondary"></i> Sem histórico
                                                @endif
                                            </td>
                                            <td>
                                                @if ($item->recorrente == 1)
                                                    Sim
                                                @else
                                                    Não
                                                @endif
                                            </td>
                                            <td>{{ $item->dias_antes_vencimento }}</td>
                                            <td>{{ $item->dias_apos_vencimento }}</td>
                                            <td>{{ date('d/m/Y', strtotime($item->data_vencimento)) }}</td>
                                            <td>{{ __data_pt($item->data_envio) }}</td>
                                            <td>{{ __data_pt($item->created_at) }}</td>
                                            <td width="300">
                                                <form action="{{ route('notificacao-cobranca.destroy', $item->id) }}"
                                                    method="post" id="form-{{ $item->id }}">
                                                    @method('delete')
                                                    @csrf
                                                    <a class="btn btn-warning btn-sm"
                                                        href="{{ route('notificacao-cobranca.edit', $item->id) }}">
                                                        <i class="ri-edit-line"></i>
                                                    </a>
                                                    <button type="button" class="btn btn-danger btn-sm btn-delete"><i
                                                            class="ri-delete-bin-line"></i></button>
                                                </form>
                                            </td>
                                        </tr>
                                        @empty
                                            <tr>
                                                <td colspan="8" class="text-center">Nada encontrado</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                            {!! $data->appends(request()->all())->links() !!}
                        </div>

                    </div>
                </div>
            </div>
        </div>
    @endsection

    @section('js')
        <script type="text/javascript" src="/js/delete_selecionados.js"></script>
    @endsection
