<?php

namespace App\Services;

use Dompdf\Dompdf;
use Dompdf\Options;
use App\Models\Nfce;
use App\Models\TaxaPagamento;

class CupomNaoFiscal
{
    protected $venda;
    protected $config;
    protected $tipo;

    public function __construct($venda, $config, $tipo = 0)
    {
        $this->venda = $venda;
        $this->config = $config;
        $this->tipo = $tipo;
    }

    public function render()
    {
        $options = new Options();
        $options->set('isRemoteEnabled', true);
        $options->set('isHtml5ParserEnabled', true);
        $options->set('dpi', 360);
        $options->set('defaultFont', 'Courier');
        $options->set('isFontSubsettingEnabled', true);
        $options->set('defaultMediaType', 'print');
        $options->set('defaultPaperSize', 'custom');
        $options->set('defaultPaperOrientation', 'portrait');
        $options->set('isPhpEnabled', true);
        $options->set('isRemoteEnabled', true);
        $options->set('isHtml5ParserEnabled', true);
        $options->set('isFontSubsettingEnabled', true);
        $options->set('isJavascriptEnabled', false);
        $options->set('debugPng', false);
        $options->set('debugKeepTemp', false);
        $options->set('debugCss', false);
        $options->set('debugLayout', false);
        $options->set('debugLayoutLines', false);
        $options->set('debugLayoutBlocks', false);
        $options->set('debugLayoutInline', false);
        $options->set('debugLayoutPaddingBox', false);
        $options->set('isFontSubsettingEnabled', true);
        $options->set('isFontSubsettingEnabled', true);
        $options->set('isFontSubsettingEnabled', true);

        $dompdf = new Dompdf($options);
        $dompdf->loadHtml($this->getHtml());
        
        // Configura o papel para tamanho de bobina térmica
        // Ajustado para melhor impressão em papel térmico 80mm ou 72mm
        $dompdf->setPaper(array(0, 0, 220, 1000), 'portrait'); // 220 pontos = 79.4mm
        $dompdf->set_option('isPhpEnabled', true);
        $dompdf->set_option('isRemoteEnabled', true);
        $dompdf->set_option('isHtml5ParserEnabled', true);
        $dompdf->set_option('isFontSubsettingEnabled', true);
        
        $dompdf->render();
        
        return $dompdf->output();
    }

    protected function formataCNPJ($cnpj)
    {
        if (!$cnpj) return '';
        $cnpj = preg_replace('/[^0-9]/', '', $cnpj);
        if (strlen($cnpj) != 14) return $cnpj;
        return substr($cnpj, 0, 2) . '.' . 
               substr($cnpj, 2, 3) . '.' . 
               substr($cnpj, 5, 3) . '/' . 
               substr($cnpj, 8, 4) . '-' . 
               substr($cnpj, 12, 2);
    }

    protected function getHtml()
    {
        $html = '
        <html>
        <head>
            <meta charset="utf-8">
            <style>
                @page {
                    margin: 1mm;
                }
                body { 
                    font-family: monospace;
                    font-size: 10pt;
                    margin: 0;
                    padding: 0;
                    width: 100%;
                    line-height: 1.2;
                    color: #000000;
                    font-weight: 500;
                }
                .header {
                    text-align: center;
                    margin-bottom: 15px;
                    width: 100%;
                    padding: 0 0 10px 0;
                    border-bottom: 1px dashed #000;
                }
                .header-info {
                    font-size: 11pt;
                    margin: 5px 0;
                    text-align: center;
                }
                .header-info span {
                    display: block;
                    width: 100%;
                    text-align: center;
                }
                .header {
                    text-align: center;
                    margin-bottom: 15px;
                    width: 100%;
                    padding: 0 0 10px 0;
                    border-bottom: 1px dashed #000;
                }
                .empresa-nome {
                    font-size: 12pt;
                    font-weight: 900;
                    margin-top: 5px;
                    margin-bottom: 5px;
                    color: #000000;
                }
                .empresa-documentos {
                    font-size: 9pt;
                    margin: 5px 0;
                    text-align: center;
                }
                .vendedor-nome {
                    font-size: 9pt;
                    color: #000000;
                }
                .cabecalho-itens {
                    font-size: 9pt;
                    margin: 5px 0;
                    text-align: left;
                    margin-left: 15px;
                }
                .item {
                    margin: 5px 0;
                }
                .item-nome {
                    font-weight: 700;
                    color: #000000;
                }
                .total {
                    margin-top: 15px;
                    border-top: 1px dashed #000;
                    padding-top: 10px;
                }
                .subtotal {
                    text-align: right;
                    margin: 5px 0;
                    font-size: 12pt;
                    font-weight: 600;
                    color: #000000;
                }
                .pagamento {
                    margin: 10px 0;
                    padding: 5px 0;
                    border-top: 1px dashed #000;
                    border-bottom: 1px dashed #000;
                }
                .centered {
                    text-align: center;
                }
                .divisor {
                    border-top: 1px dashed #000;
                    margin: 10px 0;
                }
                .cliente-info {
                    margin: 10px 0;
                    padding: 5px 0;
                    text-align: left;
                    margin-left: 15px;
                    font-size: 9pt;
                }
                table {
                    font-size: 14pt;
                }
                .total table {
                    font-size: 12pt;
                    font-weight: 600;
                    color: #000000;
                }
                .espaco-centralizado {
                    margin-top: 75px;
                    margin-bottom: 75px;
                    text-align: center;
                    font-size: 12pt;
                    font-weight: 600;
                    color: #000000;
                }
            </style>
        </head>
        <body>';
        
            // Cabeçalho com dados da empresa
            $html .= '<div class="empresa-nome">' . $this->config->nome . '</div>';
            $html .= '<div class="empresa-documentos"><span>CNPJ: ' . $this->formataCNPJ($this->config->cpf_cnpj) . '</span></div>';
            $html .= '<span>' . $this->config->rua . ', ' . $this->config->numero . '</span>'; 
            //     if($this->config->complemento) {
            //         $html .= '<span>' . $this->config->complemento . '</span>';
            //     }
            $html .= '<div class="endereco">' . $this->config->bairro .'</div>';
            $html .= '<div class="endereco">' . $this->config->cidade->nome . '/' . $this->config->cidade->uf . ' - ' . $this->config->cep . '</div>';
            $html .= '<div class="centered">---------------------------------------</div>';

           // Cabeçalho do cupom
            $html .= '<div class="espaco-centralizado"><strong>***COMPROVANTE DE VENDA***</strong></div>';
            
            // Dados do cliente se houver
            if($this->venda->cliente) {
                $html .= '<div class="centered">---------------------------------------</div>';
                $html .= '<div class="centered">**DADOS DO CLIENTE**</div>';
                $html .= '<div class="centered">---------------------------------------</div>';
                $html .= '<div class="cliente-info">';
                $html .= '<div>' . $this->venda->cliente->razao_social . '</div>';

                $html .= '<div>CPF/CNPJ: ' . $this->formataCPFCNPJ($this->venda->cliente->cpf_cnpj) . '</div>';
                $html .= '<div>Telefone: ' . $this->venda->cliente->telefone . '</div>';
                $html .= '<div>Endereço: ' . $this->venda->cliente->endereco . '</div>';
                $html .= '<div>Cidade  : ' . $this->venda->cliente->cidade->nome . '/' . $this->config->cidade->uf . ' - ' . $this->venda->cliente->cep . '</div>';
            }


        $html .= '<div class="centered">---------------------------------------</div>';
        $html .= '<div class="cabecalho-itens">ITEM&nbsp;&nbsp;&nbsp;&nbsp;UND.&nbsp;&nbsp;&nbsp;&nbsp;UNIT.&nbsp;&nbsp;&nbsp;&nbsp;QTD.&nbsp;&nbsp;&nbsp;&nbsp;TOTAL</div>';
        $html .= '<div class="centered">---------------------------------------</div>'; 
        
        // Itens da venda
        $i = 1;
        foreach ($this->venda->itens as $item) {
            $valor_unitario = 0;
            if (is_numeric($item->valor) && $item->valor > 0) {
                $valor_unitario = floatval($item->valor);
            } elseif (is_numeric($item->produto->valor_unitario) && $item->produto->valor_unitario > 0) {
                $valor_unitario = floatval($item->produto->valor_unitario);
            }
            $quantidade = is_numeric($item->quantidade) && $item->quantidade > 0 
                ? floatval($item->quantidade) 
                : 1;
            $valor_total = $quantidade * $valor_unitario;
            // Primeira linha: código e nome do produto
            
            $html .= '<div style="font-family: monospace; font-size: 9pt;">' 
                // . str_pad($i, 2, "0", STR_PAD_LEFT) . ' ' 
                . str_pad($item->produto->id, 6, "0", STR_PAD_LEFT) . ' ' 
                . $item->produto->nome 
                . '</div>';
            
            // Segunda linha: quantidade, unidade, valor unitário e total, alinhados com espaços
            $linha2 = str_repeat('&nbsp;', 3)
                . ($item->produto->unidade_venda ?? 'UN'). '   '. number_format($quantidade, 3, ',', '.') 
                . str_repeat('&nbsp;', 4).'x ' 
                . number_format($valor_unitario, 2, ',', '.')
                . str_repeat('&nbsp;', 4)
                . '= ' . number_format($valor_total, 2, ',', '.');
            $html .= '<div style="font-family: monospace; font-size: 9pt;">' . $linha2 . '</div>';
            $i++;
        }
        
        // Subtotal e descontos
        // Calcula o subtotal manualmente
        $subtotal = 0;
        foreach ($this->venda->itens as $item) {
            $valor_unitario = 0;
            if (is_numeric($item->valor) && $item->valor > 0) {
                $valor_unitario = floatval($item->valor);
            } elseif (is_numeric($item->produto->valor_unitario) && $item->produto->valor_unitario > 0) {
                $valor_unitario = floatval($item->produto->valor_unitario);
            }
            
            $quantidade = is_numeric($item->quantidade) && $item->quantidade > 0 
                ? floatval($item->quantidade) 
                : 1;
                
            $subtotal += $valor_unitario * $quantidade;
        }

        $html .= '</div>';
        
        // Total e Pagamento

        $html .= '<div class="total">';
        $html .= '<div class="centered">---------------------------------------</div>'; 
        $html .= '<table width="100%" style="font-size: 9pt;">';
        $html .= '<tr>';
        $html .= '<td><strong>VALOR TOTAL</strong></td>';
        $html .= '<td align="right"><strong>R$ ' . number_format($this->venda->total + ($this->venda->desconto ?? 0), 2, ',', '.') . '</strong></td>';
        $html .= '</tr>';

        if($this->venda->desconto > 0) {
            $html .= '<tr>';
            $html .= '<td>DESCONTOS</td>';
            $html .= '<td align="right">R$ ' . number_format($this->venda->desconto, 2, ',', '.') . '</td>';
            $html .= '</tr>';
        }

        $html .= '<tr>';
        $html .= '<td><strong>VALOR RECEBIDO</strong></td>';
        $html .= '<td align="right"><strong>R$ ' . number_format($this->venda->dinheiro_recebido, 2, ',', '.') . '</strong></td>';
        $html .= '</tr>';

        $html .= '<tr>';
        $html .= '<td><strong>TROCO</strong></td>';
        $html .= '<td align="right"><strong>R$ ' . number_format($this->venda->troco, 2, ',', '.') . '</strong></td>';
        $html .= '</tr>';
        $html .= '</table>';
        $html .= '</div>';

        $html .= '<div class="centered">---------------------------------------</div>'; 
        $html .= '<div style="text-align: left; margin-top: 3px;"><strong>FORMA(s) DE PAGAMENTO(s)</strong></div>';
        
        // Busca o mapeamento padrão de códigos para nomes das formas de pagamento
        $formasPagamentoMapeamento = \App\Models\PreVenda::tiposPagamento();

        // Pega o código da venda (garante que é string e com 2 dígitos)
        $codigo = str_pad($this->venda->tipo_pagamento, 2, '0', STR_PAD_LEFT);

        // Busca o nome no mapeamento, usando o código como chave
        // Se não encontrar, mostra o código original
        $nomeForma = $formasPagamentoMapeamento[$codigo] ?? 'Código desconhecido: ' . $this->venda->tipo_pagamento;

        $html .= '<div style="text-align: left;">' . $nomeForma . '</div>';
        
        // Rodapé
        $html .= '<div class="centered" style="margin-top: 40px; margin-bottom: 60px;">';
        $html .= '---------------------------------------<br>';
        $html .= '<div style="margin: 15px 0;"><strong>OBRIGADO PELA PREFERÊNCIA!</strong></div>';
        $html .= '<div style="margin: 8px 0;">Não tem valor fiscal</div>';
        $html .= '<div style="margin-top: 8px;">' . date('d/m/Y H:i:s') . '</div>';
        $html .= '<div class="item">Nº Venda: ' . str_pad($this->venda->id, 6, "0", STR_PAD_LEFT) . '</div>';
        // Verifica se existe vendedor/funcionário associado
        if($this->venda->funcionario) {
            $html .= '<div class="vendedor-nome">Vendedor: ' . $this->venda->funcionario->nome . '</div>';
        } else {
            $html .= '<div class="vendedor-nome">Vendedor: NÃO INFORMADO</div>';
        }



        if($this->config->site) {
            $html .= $this->config->site;
        }
        $html .= '</div>';
        
        // Avanço de papel ao final
        for ($j = 0; $j < 15; $j++) {
            $html .= '<br>';
        }
        $html .= '</body></html>';
        
        return $html;

    // Busca o mapeamento padrão de códigos para nomes das formas de pagamento
    $formasPagamentoMapeamento = \App\Models\PreVenda::tiposPagamento();

    // Pega o código da venda (garante que é string e com 2 dígitos)
    $codigo = str_pad($this->venda->tipo_pagamento, 2, '0', STR_PAD_LEFT);

    // Busca o nome no mapeamento, usando o código como chave
    // Se não encontrar, mostra o código original
    $nomeForma = $formasPagamentoMapeamento[$codigo] ?? 'Código desconhecido: ' . $this->venda->tipo_pagamento;

    $html .= '<div style="text-align: left;">' . $nomeForma . '</div>';

     return $html;
     }

    protected function formataCPFCNPJ($doc) {
        $doc = preg_replace("/[^0-9]/", "", $doc);
        if(strlen($doc) === 11) {
            return preg_replace("/^(\d{3})(\d{3})(\d{3})(\d{2})$/", "$1.$2.$3-$4", $doc);
        }
        return preg_replace("/^(\d{2})(\d{3})(\d{3})(\d{4})(\d{2})$/", "$1.$2.$3/$4-$5", $doc);
    }
}
