<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('notificacoes_cobrancas', function (Blueprint $table) {
            $table->id();
            $table->foreignId('empresa_id')->nullable()->constrained('empresas');
            $table->string('whatsapp')->nullable();
            $table->string('titulo')->nullable();
            $table->enum('gateway', ['pay_mundi', 'onz_finance'])->nullable();
            $table->tinyInteger('status')->default(0);
            $table->timestamp('data_envio')->nullable();
            $table->date('data_vencimento')->nullable();
            $table->string('dias_antes_vencimento', 150)->nullable();
            $table->string('dias_apos_vencimento', 150)->nullable();
            $table->integer('criador_id')->nullable();
            $table->tinyInteger('recorrente')->default(1);
            $table->string('cliente', 250)->nullable();
            $table->string('cpf_cnpj', 150)->nullable();
            $table->decimal('valor', 10, 2)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('notificacoes_cobrancas');
    }
};
