<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateConsignmentItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('consignment_items', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('consignment_id');
            $table->unsignedBigInteger('produto_id');
            $table->unsignedBigInteger('produto_variacao_id')->nullable();
            $table->decimal('quantidade_consignada', 10, 3);
            $table->decimal('quantidade_devolvida', 10, 3)->default(0);
            $table->decimal('quantidade_vendida', 10, 3)->default(0);
            $table->decimal('valor_unitario', 10, 2);
            $table->timestamps();

            $table->foreign('consignment_id')->references('id')->on('consignments')->onDelete('cascade');
            $table->foreign('produto_id')->references('id')->on('produtos');
            $table->foreign('produto_variacao_id')->references('id')->on('produto_variacoes')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('consignment_items');
    }
}
