@extends('layouts.app', ['title' => 'Nova Consignação'])
@section('content')

<div class="card card-custom gutter-b">
    <div class="card-header flex-wrap border-0 pt-6 pb-0">
        <div class="card-title">
            <h3 class="card-label">
                {{ $titulo }}
                <small>Adicione os produtos para consignação</small>
            </h3>
        </div>
        <div class="card-toolbar">
            <a href="{{ route('consignments.index') }}" class="btn btn-secondary">
                <i class="la la-angle-left"></i>Voltar
            </a>
        </div>
    </div>

    <div class="card-body">
        <form action="{{ route('consignments.store') }}" method="post" id="form-consignment">
            @csrf
            <div class="row">
                <div class="col-lg-4 col-md-6 col-sm-6">
                    <div class="form-group">
                        <label>Cliente:</label>
                        <select name="cliente_id" id="cliente_id" class="form-control select2" required>
                            <option value="">Selecione o cliente</option>
                            @foreach($clientes as $cliente)
                            <option value="{{ $cliente->id }}">{{ $cliente->razao_social }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 col-sm-6">
                    <div class="form-group">
                        <label>Data de Abertura:</label>
                        <div class="input-group date">
                            <input type="text" name="data_abertura" class="form-control" id="data_abertura" required value="{{ date('d/m/Y') }}" />
                            <div class="input-group-append">
                                <span class="input-group-text">
                                    <i class="la la-calendar"></i>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="row">
                <div class="col-lg-12">
                    <div class="form-group">
                        <label>Observação:</label>
                        <textarea name="observacao" id="observacao" class="form-control" rows="3"></textarea>
                    </div>
                </div>
            </div>
            
            <div class="separator separator-dashed my-5"></div>
            
            <div class="row mb-5">
                <div class="col-lg-12">
                    <h4>Produtos para Consignação</h4>
                </div>
            </div>
            
            <div class="row mb-3">
                <div class="col-lg-10">
                    <label for="selectable_product_list">Selecione os Produtos (segure Ctrl/Cmd para selecionar múltiplos):</label>
                    <select multiple class="form-control" id="selectable_product_list" name="selectable_product_list[]" size="10">
                        @if(isset($selectable_products) && count($selectable_products) > 0)
                            @foreach($selectable_products as $product_info)
                                <option value="{{ $product_info['id_attr'] }}" 
                                        data-produto-id="{{ $product_info['produto_id'] }}"
                                        data-variacao-id="{{ $product_info['variacao_id'] ?? '' }}"
                                        data-nome-produto="{{ Illuminate\Support\Str::limit(addslashes($product_info['nome_produto']), 50) }}"
                                        data-nome-variacao="{{ Illuminate\Support\Str::limit(addslashes($product_info['nome_variacao'] ?? ''), 30) }}"
                                        data-valor="{{ $product_info['valor'] }}"
                                        data-estoque="{{ $product_info['estoque_disponivel'] }}">
                                    {{ $product_info['display_text'] }} (Estoque: {{ $product_info['estoque_disponivel'] }})
                                </option>
                            @endforeach
                        @else
                            <option disabled>Nenhum produto disponível para seleção ou com estoque.</option>
                        @endif
                    </select>
                </div>
                <div class="col-lg-2 align-self-end">
                    <button type="button" class="btn btn-primary btn-block" id="btn-adicionar-selecionados" style="margin-top: 28px;"> <!-- Ajuste de margem para alinhar com label -->
                        Adicionar Selecionados
                    </button>
                </div>
            </div>
            
            <div class="separator separator-dashed my-5"></div>
            
            <div class="row">
                <div class="col-lg-12">
                    <div class="table-responsive">
                        <table class="table table-hover table-striped" id="produtos-table">
                            <thead>
                                <tr>
                                    <th>Produto</th>
                                    <th>Valor Unitário</th>
                                    <th>Quantidade</th>
                                    <th>Total</th>
                                    <th>Ação</th>
                                </tr>
                            </thead>
                            <tbody id="produtos-consignados">
                                <tr id="empty-row">
                                    <td colspan="5" class="text-center">Nenhum produto adicionado à consignação</td>
                                </tr>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td colspan="3" class="text-right"><strong>Total:</strong></td>
                                    <td id="total-consignacao">R$ 0,00</td>
                                    <td></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
            
            <div class="row mt-5">
                <div class="col-lg-12 text-right">
                    <button type="submit" id="btn-salvar" class="btn btn-success">
                        <i class="la la-check"></i>
                        Salvar Consignação
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

@section('javascript')
<script type="text/javascript">
    var produtos = [];
    var total = 0;

    $(function () {
        $('.select2').select2();
        
        $('#data_abertura').datepicker({
            format: 'dd/mm/yyyy',
            todayHighlight: true,
            orientation: "bottom left",
            templates: {
                leftArrow: '<i class="la la-angle-left"></i>',
                rightArrow: '<i class="la la-angle-right"></i>'
            }
        });
        
        // Adicionar produtos selecionados da listbox
        $('#btn-adicionar-selecionados').click(function() {
            const selectedOptions = $('#selectable_product_list option:selected');
            if (selectedOptions.length === 0) {
                alert('Por favor, selecione pelo menos um produto para adicionar.');
                return;
            }

            selectedOptions.each(function() {
                const option = $(this);
                const produtoId = option.data('produto-id');
                const variacaoId = option.data('variacao-id') ? String(option.data('variacao-id')) : null;
                const nomeProduto = option.data('nome-produto');
                const nomeVariacao = option.data('nome-variacao') ? String(option.data('nome-variacao')) : null;
                const valor = parseFloat(option.data('valor'));
                const estoqueDisponivel = parseInt(option.data('estoque'));
                const displayText = option.text().split(' (Estoque:')[0]; // Nome limpo para prompts

                // Verificar se o item já foi adicionado (mesmo produto_id e variacao_id)
                const itemJaAdicionado = produtos.find(p => 
                    p.produto_id === produtoId && 
                    (p.variacao_id === variacaoId || (String(p.variacao_id) === 'null' && variacaoId === null))
                );

                if (itemJaAdicionado) {
                    alert(`O produto "${displayText}" já foi adicionado. Você pode alterar a quantidade na tabela abaixo ou removê-lo para adicionar novamente.`);
                    return; // Continua para o próximo item selecionado
                }
                
                let quantidadeInput = prompt(`Digite a quantidade para "${displayText}" (Estoque disponível: ${estoqueDisponivel}):`, '1');

                if (quantidadeInput === null || quantidadeInput.trim() === '') {
                    // alert('Quantidade não informada. O produto não foi adicionado.');
                    return; // Pula este item se o usuário cancelar o prompt ou não digitar nada
                }

                const quantidade = parseInt(quantidadeInput);

                if (isNaN(quantidade) || quantidade <= 0) {
                    alert('Quantidade inválida. Por favor, insira um número positivo.');
                    return; // Pula este item
                }

                if (quantidade > estoqueDisponivel) {
                    alert(`Quantidade (${quantidade}) excede o estoque disponível (${estoqueDisponivel}) para "${displayText}".`);
                    return; // Pula este item
                }

                produtos.push({
                    id: null, // Novo item, sem ID de 'consignment_items' ainda
                    produto_id: produtoId,
                    variacao_id: variacaoId,
                    nome_produto: nomeProduto,
                    nome_variacao: nomeVariacao,
                    quantidade: quantidade,
                    valor_unitario: valor,
                    subtotal: (quantidade * valor).toFixed(2),
                    estoque_disponivel: estoqueDisponivel // Guardar para referência, se necessário
                });
            });

            renderizarProdutosAdicionados();
            $('#selectable_product_list').val([]); // Limpar seleção na listbox
        });
        
        // Validar e enviar formulário
        $('#form-consignment').submit(function(e) {
            e.preventDefault();
            
            if ($('#cliente_id').val() == '') {
                alert('Selecione um cliente');
                return false;
            }
            
            if (produtos.length == 0) {
                alert('Adicione pelo menos um produto à consignação');
                return false;
            }
            
            let formData = $(this).serializeArray();
            
            // Adicionar produtos ao formulário
            produtos.forEach(function(p, index) {
                formData.push({
                    name: `produtos[${index}][id]`,
                    value: p.id
                });
                
                formData.push({
                    name: `produtos[${index}][variacao_id]`,
                    value: p.variacao_id
                });
                
                formData.push({
                    name: `produtos[${index}][quantidade]`,
                    value: p.quantidade
                });
                
                formData.push({
                    name: `produtos[${index}][valor_unitario]`,
                    value: p.valor
                });
            });
            
            $.ajax({
                url: $(this).attr('action'),
                type: 'POST',
                data: formData,
                dataType: 'json',
                error: function(xhr, status, error) {
                    const response = xhr.responseJSON;
                    if (response && response.errors) {
                        Object.keys(response.errors).forEach(key => {
                            const messages = response.errors[key];
                            alert(messages[0]);
                        });
                    } else {
                        alert('Erro ao salvar consignação. Tente novamente.');
                    }
                },
                success: function(data) {
                    window.location.href = "{{ route('consignments.index') }}";
                }
            });
        });
    });
    
    function renderizarProdutosAdicionados() {
        const tbody = $('#produtos-consignados-body'); // Certifique-se que este é o ID do seu tbody
        const totalDisplay = $('#total-consignacao'); // Certifique-se que este é o ID do elemento para o total geral

        if (produtos.length === 0) {
            tbody.html('<tr id="empty-row"><td colspan="5" class="text-center">Nenhum produto adicionado à consignação</td></tr>'); // 5 colunas: Nome, Qtd, Vlr. Unit., Subtotal, Ação
            totalDisplay.text('0.00');
            return;
        }

        let html = '';
        let totalGeral = 0;

        produtos.forEach(function(p, index) {
            const nomeDisplay = p.nome_variacao ? `${p.nome_produto} - ${p.nome_variacao}` : p.nome_produto;
            // p.subtotal foi calculado e armazenado como string ao adicionar o produto
            const currentItemSubtotal = parseFloat(p.subtotal); 
            totalGeral += currentItemSubtotal;

            html += `
                <tr>
                    <td>${nomeDisplay}</td>
                    <td class="text-right">${p.quantidade}</td>
                    <td class="text-right">R$ ${parseFloat(p.valor_unitario).toFixed(2)}</td>
                    <td class="text-right">R$ ${currentItemSubtotal.toFixed(2)}</td>
                    <td class="text-center">
                        <button type="button" class="btn btn-sm btn-danger" onclick="removerProduto(${index})">
                            <i class="la la-trash"></i>
                        </button>
                    </td>
                </tr>
            `;
        });

        tbody.html(html);
        totalDisplay.text(totalGeral.toFixed(2));
    }
    
    function formatMoney(value) {
        return parseFloat(value).toFixed(2).replace('.', ',');
    }
</script>
@endsection

@endsection
