<?php

namespace NFePHP\EFD\Elements\ICMSIPI;

use NFePHP\EFD\Common\Element;
use stdClass;

class Z1010 extends Element
{
    const REG = '1010';
    const LEVEL = 2;
    const PARENT = '1001';

    protected $parameters = [
        'IND_EXP' => [
            'type'     => 'string',
            'regex'    => '^[S|N]$',
            'required' => true,
            'info'     => 'Reg. 1100 - Ocorreu averbação (conclusão) de exportação no período: '
            .'S– Sim '
            .'N - Não',
            'format'   => ''
        ],
        'IND_CCRF' => [
            'type'     => 'string',
            'regex'    => '^[S|N]$',
            'required' => true,
            'info'     => 'Reg 1200 – Existem informações acerca de créditos de ICMS a serem '
            .'controlados, definidos pela Sefaz: '
            .'S– Sim '
            .'N - Não',
            'format'   => ''
        ],
        'IND_COMB' => [
            'type'     => 'string',
            'regex'    => '^[S|N]$',
            'required' => true,
            'info'     => 'Reg. 1300 – É comércio varejista de combustíveis com movimentação
            '.'e/ou estoque no período: '
            .'S– Sim '
            .'N - Não',
            'format'   => ''
        ],
        'IND_USINA' => [
            'type'     => 'string',
            'regex'    => '^[S|N]$',
            'required' => true,
            'info'     => 'Reg. 1390 – Usinas de açúcar e/álcool – O estabelecimento é produtor
            '.'de açúcar e/ou álcool carburante com movimentação e/ou estoque no período: '
            .'S – Sim '
            .'N - Não',
            'format'   => ''
        ],
        'IND_VA' => [
            'type'     => 'string',
            'regex'    => '^[S|N]$',
            'required' => true,
            'info'     => 'Reg 1400 – Sendo o registro obrigatório em sua Unidade de Federação,
            '.'existem informações a serem prestadas neste registro: '
            .'S – Sim; '
            .'N - Não',
            'format'   => ''
        ],
        'IND_EE' => [
            'type'     => 'string',
            'regex'    => '^[S|N]$',
            'required' => true,
            'info'     => 'Reg 1500 - A empresa é distribuidora de energia e ocorreu fornecimento
            '.'de energia elétrica para consumidores de outra UF: '
            .'S – Sim; '
            .'N - Não',
            'format'   => ''
        ],
        'IND_CART' => [
            'type'     => 'string',
            'regex'    => '^[S|N]$',
            'required' => false,
            'info'     => 'Reg 1600 - Realizou vendas com Cartão de Crédito ou de débito: '
            .'S– Sim; '
            .'N - Não',
            'format'   => ''
        ],
        'IND_FORM' => [
            'type'     => 'string',
            'regex'    => '^[S|N]$',
            'required' => false,
            'info'     => 'Reg. 1700 – Foram emitidos documentos fiscais em papel no período em '
            .'unidade da federação que exija o controle de utilização de documentos fiscais: '
            .'S – Sim '
            .'N - Não',
            'format'   => ''
        ],
        'IND_AER' => [
            'type'     => 'string',
            'regex'    => '^[S|N]$',
            'required' => false,
            'info'     => 'Reg 1800 – A empresa prestou serviços de transporte aéreo de cargas e '
            .'de passageiros: '
            .'S– Sim '
            .'N - Não',
            'format'   => ''
        ],
        'IND_GIAF1' => [
            'type'     => 'string',
            'regex'    => '^[S|N]$',
            'required' => false,
            'info'     => 'Reg. 1960 - Possui informações GIAF1?'
                .'S– Sim '
                .'N - Não',
            'format'   => ''
        ],
        'IND_GIAF3' => [
            'type'     => 'string',
            'regex'    => '^[S|N]$',
            'required' => false,
            'info'     => 'Reg. 1960 - Possui informações GIAF3?'
                .'S– Sim '
                .'N - Não',
            'format'   => ''
        ],
        'IND_GIAF4' => [
            'type'     => 'string',
            'regex'    => '^[S|N]$',
            'required' => false,
            'info'     => 'Reg. 1960 - Possui informações GIAF4?'
                .'S– Sim '
                .'N - Não',
            'format'   => ''
        ],
        'IND_REST_RESSARC_COMPL_ICMS' => [
            'type'     => 'string',
            'regex'    => '^[S|N]$',
            'required' => false,
            'info'     => 'Reg. 1250 – Possui informações consolidadas de saldos '.
            'de restituição, ressarcimento e complementação do ICMS?'
                .'S– Sim '
                .'N - Não',
            'format'   => ''
        ],
    ];

    /**
     * Constructor
     * @param stdClass $std
     * @param stdClass $vigencia
     */
    public function __construct(stdClass $std, stdClass $vigencia = null)
    {
        parent::__construct(self::REG, $vigencia);
        $this->replaceParams( self::REG);
        $this->std = $this->standarize($std);
        $this->postValidation();
    }
}
