<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Consignment extends Model
{
    use HasFactory;

    protected $fillable = [
        'cliente_id', 
        'empresa_id', 
        'observacao', 
        'status',
        'data_abertura',
        'data_fechamento'
    ];

    protected $casts = [
        'data_abertura' => 'date',
        'data_fechamento' => 'date',
    ];

    public function cliente()
    {
        return $this->belongsTo(Cliente::class, 'cliente_id');
    }

    public function empresa()
    {
        return $this->belongsTo(Empresa::class, 'empresa_id');
    }

    public function items()
    {
        return $this->hasMany(ConsignmentItem::class, 'consignment_id');
    }

    public function getValorTotalAttribute()
    {
        $total = 0;
        foreach ($this->items as $item) {
            $total += $item->quantidade_vendida * $item->valor_unitario;
        }
        return $total;
    }

    public function getStatusTextoAttribute()
    {
        switch ($this->status) {
            case 'aberto':
                return 'Aberto';
            case 'concluido':
                return 'Concluído';
            case 'cancelado':
                return 'Cancelado';
            default:
                return 'Desconhecido';
        }
    }

    public function getStatusClassAttribute()
    {
        switch ($this->status) {
            case 'aberto':
                return 'warning';
            case 'concluido':
                return 'success';
            case 'cancelado':
                return 'danger';
            default:
                return 'secondary';
        }
    }
}
