@extends('layouts.app', ['title' => 'Conectar Whatsapp'])
@section('content')
    <div class="card mt-1">
        <div class="card-header">
            <h4>Conectar Whatsapp</h4>
            <div style="text-align: right; margin-top: -35px;">
                <a href="{{ route('notificacao-cobranca.index') }}" class="btn btn-danger btn-sm px-3">
                    <i class="ri-arrow-left-double-fill"></i>Voltar
                </a>
            </div>
        </div>
        <div class="card-body">
            <div class="instrucoes">
                <div>
                    <h3 class="text-center">Leia todos os passos abaixo e clique no botão no final dessa página</h3>
                </div>

                <div>
                    <img src="/scan-demo.gif" class="scanImg">
                </div>
                <div class="activities mt-4">
                    <div class="activity">
                        <div class="activity-icon bg-primary text-white shadow-primary">
                            <i class="ri-smartphone-fill"></i>
                        </div>
                        <div class="activity-detail">
                            <div class="mb-2">
                                <span class="text-job text-primary">Passo 1</span>
                                <span class="bullet"></span>
                            </div>
                            <p>Acesse a App Store ou Play Store e atualize para a última versão do WhatsApp</p>
                        </div>
                    </div>
                    <div class="activity">
                        <div class="activity-icon bg-primary text-white shadow-primary">
                            <i class="ri-smartphone-fill"></i>
                        </div>
                        <div class="activity-detail">
                            <div class="mb-2">
                                <span class="text-job text-primary">Passo 2</span>
                                <span class="bullet"></span>
                            </div>
                            <p>Abra o WhatsApp no celular que o bot será instalado</p>
                        </div>
                    </div>
                    <div class="activity">
                        <div class="activity-icon bg-primary text-white shadow-primary">
                            <i class="ri-check-double-line"></i>
                        </div>
                        <div class="activity-detail">
                            <div class="mb-2">
                                <span class="text-job text-primary">Passo 3</span>
                                <span class="bullet"></span>
                            </div>
                            <p>Clique em Menu ou Configurações</p>
                        </div>
                    </div>
                    <div class="activity">
                        <div class="activity-icon bg-primary text-white shadow-primary">
                            <i class="ri-check-double-line"></i>
                        </div>
                        <div class="activity-detail">
                            <div class="mb-2">
                                <span class="text-job text-primary">Passo 4</span>
                                <span class="bullet"></span>
                            </div>
                            <p>Clique em Aparelhos conectados</p>
                        </div>
                    </div>
                    <div class="activity">
                        <div class="activity-icon bg-primary text-white shadow-primary">
                            <i class="ri-check-double-line"></i>
                        </div>
                        <div class="activity-detail">
                            <div class="mb-2">
                                <span class="text-job text-primary">Passo 5</span>
                                <span class="bullet"></span>
                            </div>
                            <p>Se você já tinha o bot conectado, remova-o primeiro</p>
                        </div>
                    </div>
                    <div class="activity">
                        <div class="activity-icon bg-primary text-white shadow-primary">
                            <i class="ri-check-double-line"></i>
                        </div>
                        <div class="activity-detail">
                            <div class="mb-2">
                                <span class="text-job text-primary">Passo 6</span>
                                <span class="bullet"></span>
                            </div>
                            <p>Clique em Conectar um aparelho</p>
                        </div>
                    </div>
                    <div class="activity">
                        <div class="activity-icon bg-primary text-white shadow-primary">
                            <i class="ri-qr-code-fill"></i>
                        </div>
                        <div class="activity-detail">
                            <div class="mb-2">
                                <span class="text-job text-primary">Passo 7</span>
                                <span class="bullet"></span>
                            </div>
                            <p>Quando estiver pronto para scannear o código no celular onde o bot será instalado
                                clique no botão abaixo</p>
                        </div>
                    </div>
                </div>

                <div class="mt-4">
                    <button type="button" class="btn btn-primary w-100 ready-to-scan">🚀 Já fiz os passos e estou pronto
                        para
                        scannear</button>
                </div>
            </div>

            <div class="qrcode d-none">
                <div class="col-md-4 offset-md-4">
                    <div class="attempts text-center">
                        <div>
                            Tentativa <span class="attempt">1</span> de 20
                        </div>
                        <br>
                        <div class="mt-4">
                            Aponte sua câmera para essa parte
                        </div>
                    </div>

                    <div class="text-center loading">
                        <div class="spinner-grow text-primary" role="status">
                            <span class="sr-only">Carregando...</span>
                        </div>
                        <br>
                        <p><strong>Carregando QR Code</strong></p>
                    </div>

                    <div class="text-center content">
                        <img src="" alt="base64QRCode" class="w-100 qrcodeIMG">
                    </div>
                </div>
            </div>
        </div>


    </div>
@endsection

@section('css')
    <link rel="stylesheet" href="/css/qrcode.css">
@stop

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        var sessionMake;
        let attempt = 0;
        let session_attempt = 0;

        $(document).ready(function() {

            $('.ready-to-scan, .generate-btn').click(function() {
                $('.instrucoes').addClass('d-none');
                $('.qrcode').removeClass('d-none');
                $('.qrcode .loading').show();
                $('.qrcode .content').hide();

                $.ajax({
                    url: '/notificacao-cobranca-qr?start=1',
                    type: 'GET',
                    success: function(response) {
                        $('.qrcode .loading').hide();
                        $('.qrcode .content').show();

                        if (response.status == 'connected') {
                            Swal.fire({
                                title: "Aviso",
                                text: "O seu número foi conectado com sucesso.",
                                icon: "success",
                                showCancelButton: false,
                                willClose: () => {
                                    location.reload();
                                }
                            }).then((result) => {
                                if (result.value == true) {
                                    location.href = '/notificacao-cobranca'
                                }
                            });
                        } else {
                            if (response.qr.base64 == '') {
                                $('.qrcode .content .qrcodeIMG').hide();
                                $('.qrcode .content .generate-btn').hide();
                            } else {
                                $('.qrcode .content .qrcodeIMG').attr('src', response.qr
                                    .base64);
                                sessionMake = setInterval(() => {
                                    createSession('true');
                                }, 10000);
                            }
                        }
                    }
                });
            });
        });

        function createSession(connect) {
            attempt++;
            $(".attempt").html(attempt);

            if (attempt >= 20) {
                clearInterval(sessionMake);

                wal.fire({
                    title: "Ops!",
                    text: "As tentativas expiraram, tente novamente.",
                    icon: "warning",
                    showCancelButton: false,
                    confirmButtonColor: "#3085d6",
                    cancelButtonColor: "#d33",
                    cancelButtonText: "Fechar",
                    confirmButtonText: "Recarregar",
                    willClose: () => {
                        location.reload();
                    }
                }).then((result) => {
                    if (result.value == true) {
                        location.reload();
                    }
                });

                return false;
            } else {
                $.ajax({
                    url: '/notificacao-cobranca-qr?start=0',
                    type: 'GET',
                    success: function(response) {
                        if (response.status == 'connected') {
                            Swal.fire({
                                title: "Aviso",
                                text: "O seu número foi conectado com sucesso.",
                                icon: "success",
                                showCancelButton: false,
                                willClose: () => {
                                    location.reload();
                                }
                            }).then((result) => {
                                if (result.value == true) {
                                    location.href = '/notificacao-cobranca'
                                }
                            });
                        } else {
                            if (response.qr.base64 == '') {
                                $('.qrcode .content .qrcodeIMG').hide();
                                $('.qrcode .content .generate-btn').hide();
                            } else {
                                $('.qrcode .content .qrcodeIMG').attr('src', response.qr.base64);
                            }
                        }
                    }
                });
            }
        }
    </script>
@stop
